-- Sea el siguiente tipo para representar polinomios de variable real:

type Grado 	 = Int
type Coeficiente = Float
type Monomio	 = (Coeficiente, Grado)

infixr 9 :+:
data Polinomio	 = PoliNulo 
                 | Monomio :+: Polinomio deriving Show
                 
-- Los monomios aparecern en orden decreciente. Por ejemplo, el polinomio
-- 5.0 x^2 + 7.0 x + 2 se representa como:

p1 :: Polinomio
p1 = (5.0, 2) :+: (7.0, 1) :+: (2.0, 0) :+: PoliNulo

p2 :: Polinomio
p2 = (8.0, 3) :+: (9.0, 1) :+: PoliNulo

-- Escribir la funcin mapPoli (map pero actuando sobre polinomios)
-- con el siguiente tipo:
-- mapPoli :: (Monomio -> Monomio) -> Polinomio -> Polinomio

-- A --
                 
mapPoli :: (Monomio -> Monomio) -> Polinomio -> Polinomio
mapPoli f PoliNulo  = PoliNulo
mapPoli f (m :+: p) = f m :+: mapPoli f p 


-- Escribir una funcin evalPoli 
-- evalPoli :: Float -> Polinomio -> Float
-- que evale un polinomio en un valor de la variable, P.ej.
-- ? evalPoli 2.0 p1
-- 36.0
-- (24 reductions, 61 cells)  

-- B --

evalPoli :: Float -> Polinomio -> Float
evalPoli x PoliNulo      = 0.0
evalPoli x ((c,g) :+: p) = c*x^g + evalPoli x p


-- C ---


-- Sea la siguiente funcin de plegado para el tipo polinomio:

pliegaPoli :: (Monomio -> a -> a) -> a -> Polinomio -> a 
pliegaPoli f e PoliNulo  = e
pliegaPoli f e (m :+: p) = f m (pliegaPoli f e p)


-- Escribir, usando la funcin de plegado, evalPoli':
-- evalPoli' :: Float -> Polinomio -> Float
-- que evala un polinomio en un valor de la variable.

evalPoli' :: Float -> Polinomio -> Float
evalPoli' x = pliegaPoli (\(c,g) evalResto -> c*x^g + evalResto) 0.0


-- D --

-- Escribir un operador <+> que obtenga el polinomio suma de otros dos:
-- infixl 6 <+>
-- (<+>) :: Polinomio -> Polinomio -> Polinomio

infixl 6 <+>
(<+>) :: Polinomio -> Polinomio -> Polinomio
PoliNulo           <+> p2                  = p2
p1                 <+> PoliNulo            = p1
p1@((c1,g1):+:pr1) <+> p2@((c2,g2):+:pr2)
	| g1 >  g2 = (c1,g1)    :+: (pr1 <+> p2)
 	| g2 >  g1 = (c2,g2)    :+: (p1  <+> pr2)
	| g2 == g1 = (c1+c2,g1) :+: (pr1 <+> pr2)


-- E ---

infixl 7 <*>
(<*>) :: Polinomio -> Polinomio -> Polinomio
p1 <*> p2 = pliegaPoli (\mon p -> mon `por` p1 <+> p) PoliNulo p2



-- Producto de Monomio por Polinomio
por :: Monomio -> Polinomio -> Polinomio
_       `por` PoliNulo       = PoliNulo
m@(c,g) `por` ((c',g'):+:p') = (c*c',g+g') :+: por m p'


por' :: Monomio -> Polinomio -> Polinomio
por' (c,g) = pliegaPoli (\(c',g') p -> (c*c',g+g'):+:p) PoliNulo






evalPoli'' x = pliegaPoli (\(c,g) evalResto -> x * evalResto + c) 0.0


spanPoli :: (Monomio -> Bool) -> Polinomio -> (Polinomio, Polinomio)
spanPoli f PoliNulo  = (PoliNulo, PoliNulo)
spanPoli f (m :+: p) | f m       = (m :+: izq, der)
                     | otherwise = (izq,       m :+: der)
  where (izq, der) = spanPoli f p                   

                       
agrupa :: Polinomio -> Polinomio
agrupa PoliNulo        = PoliNulo
agrupa p@((_,g) :+: _) = (sumar iguales, g) :+: agrupa distintos
 where (iguales, distintos) = spanPoli (\(_,g') -> g == g') p
       sumar = pliegaPoli (\(c,_) sumaResto -> c + sumaResto) 0.0

esCero :: Polinomio -> Bool
esCero PoliNulo      = True
esCero ((c,g) :+: p) = c == 0.0  &&  esCero p

esCero' :: Polinomio -> Bool
esCero' = pliegaPoli (\(c,g) b -> c == 0.0  && b) True
